﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace CustomerManager
{
  /// <summary>
  /// Logika interakcji z oknem MainWindow.xaml.
  /// </summary>
  public partial class MainWindow : Window
  {

    CustomerProfileService.CustomerProfileSoapClient _custProfileSrv =
      new CustomerProfileService.CustomerProfileSoapClient();
    
    public MainWindow()
    {
      InitializeComponent();
    }

    private void buttonCancel_Click(object sender, RoutedEventArgs e)
    {
      this.Close();
    }

    private void Window_Loaded(object sender, RoutedEventArgs e)
    {
      this.LoadGrid();
    }

    private void LoadGrid()
    {
      System.Data.DataSet custDs = _custProfileSrv.GetActiveCustomers();
      dataGrid1.DataContext = custDs.Tables[0];    
    }

    private void buttonEdit_Click(object sender, RoutedEventArgs e)
    {

      if (dataGrid1.SelectedItem != null)
      {
        System.Data.DataRowView rv = (System.Data.DataRowView)dataGrid1.SelectedItem;
        string custId = rv.Row["CustomerID"].ToString();
        EditCustomer edit = new EditCustomer(custId);
        edit.ShowDialog();
        this.LoadGrid();
      }
      else
      {
        MessageBox.Show("Zaznacz klienta na liście.");
      }
    }

    private void buttonDelete_Click(object sender, RoutedEventArgs e)
    {
      if (dataGrid1.SelectedItem != null)
      {
        System.Data.DataRowView rv = (System.Data.DataRowView)dataGrid1.SelectedItem;
        string custId = rv.Row["CustomerID"].ToString();
        if (MessageBox.Show ("Czy na pewno chcesz usunąć klienta " + custId + "?", 
          "Potwierdzenie usuwania", MessageBoxButton.OKCancel) == MessageBoxResult.OK)
        {
          _custProfileSrv.DeleteCustomer(custId);
          this.LoadGrid();          
        }
      }
      else
      {
        MessageBox.Show("Zaznacz klienta na liście.");
      }

    }

    private void buttonNew_Click(object sender, RoutedEventArgs e)
    {
      // Do zrobienia: tryb tworzenia nowego klienta w oknie EditCustomer.xaml.

    }
  }
}
